% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_header_parser.R
\name{mod_header_parser}
\alias{mod_header_parser}
\title{Parse the header of module modules to add to the database}
\usage{
mod_header_parser(filePath)
}
\arguments{
\item{filePath}{The file path to the R module script to be added.}
}
\value{
A list containing dataframes that can be used to update the shinyMgr
database. These include:
  1. Data for the modules table
  2. Data for updating the modFunctionArguments table
  3. Data for updating the modFunctionReturns table
}
\description{
This is a helper function that parses the header of modules to
pending addition to the shinymgr.sqlite database. This is used as a helper 
function by \code{\link{mod_register}} and \code{\link{check_mod_info}} to convert 
the data in headers into dataframes.
}
\examples{

# establish the path to a built-in shinymgr module
filePath <- file.path(find.package('shinymgr'), 'shinymgr/modules/poly_fit.R')

# Parse the header and return associated data as a list of dataframes.
data_to_add <- mod_header_parser(filePath)

# look at the result
str(data_to_add)

}
\seealso{
Other module: 
\code{\link{check_mod_info}()},
\code{\link{mod_init}()},
\code{\link{mod_register}()}
}
\concept{module}
