% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_init.R
\name{mod_init}
\alias{mod_init}
\title{Creates an R script that contains a framework for developing a new 
module}
\usage{
mod_init(modName, author, shinyMgrPath)
}
\arguments{
\item{modName}{The name of the module to be added to the modules table of
the shinymgr.sqlite database. The function will write an R script as 
modName.R}

\item{author}{A string with the author's name, formatted as "Lastname, 
Firstname".}

\item{shinyMgrPath}{The path to the shinymgr project. Typically the 
working directory.}
}
\value{
Invisible. The function will write an R script with the name 
modName.R and store the file in the shinymgr project's modules folder.
}
\description{
Creates an R script that contains a framework for developing a 
new module
}
\section{More Info}{

The mod_init() function is described in the "shinymgr_modules" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{
## Only run this example in interactive R sessions
if (interactive()) {

# set the file path to the main shinymgr directory
parentPath <- tempdir()
shinyMgrPath <- paste0(parentPath, '/shinymgr')

shinymgr_setup(parentPath = parentPath, demo = FALSE)

mod_init(
  modName = "my_test_mod", 
  author = "Baggins, Bilbo", 
  shinyMgrPath = shinyMgrPath
)

# the file should be located in the shinymgr/modules directory
fp <- paste0(shinyMgrPath, "/modules/my_test_mod.R")

# determine if the file exists
file.exists(fp)

# show the file info
file.info(fp)

# show the file
file.show(fp)

# remove demo
unlink(shinyMgrPath, recursive = TRUE)

}

}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other module: 
\code{\link{check_mod_info}()},
\code{\link{mod_header_parser}()},
\code{\link{mod_register}()}
}
\concept{module}
