% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_db_create.R
\name{shiny_db_create}
\alias{shiny_db_create}
\title{Create an empty *shinymgr* SQLite database, and populate with 
demo data if desired.}
\usage{
shiny_db_create(db_path, demo)
}
\arguments{
\item{db_path}{Filepath that will house the sqlite database}

\item{demo}{Logical. Should demo data be included?}
}
\value{
Returns a *shinymgr* SQLite database.
}
\description{
Create an empty *shinymgr* SQLite database for managing
multiple apps and scripts in a common framework.  This function is
typically not called; instead use \code{\link{shinymgr_setup}}
}
\details{
The *shinymgr* database is a SQLite database.  The function uses
the R package, RSQLite, to connect the database with R (the package
itself contains SQLite, so no external software is needed.  Once the
connection is made, the function uses database functions
from the package, DBI, which in turn can be used to query the database,
add records, etc.) This function is not intended to be used. 
Rather, users should use \code{\link{shinymgr_setup}} to create the
database  instance that comes with the package.  The function is
included here so users can inspect the code used to create the database.
}
\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{

# ------------------------------------------------------------
# Set up an empty database for demonstration and then delete it
# ------------------------------------------------------------

# create the database (to be deleted):
db_dir <- tempdir()
db_path <- paste0(db_dir, "/shinymgr.sqlite")
shiny_db_create(
  db_path  = db_path,
  demo = TRUE)

# verify that the database exists in your current working directory
file.exists(db_path)

# to work with a database *outside* of a *shinymgr* function, 
# load the DBI package first and use RSQLite to set the driver
conx <- DBI::dbConnect(drv = RSQLite::SQLite(), dbname = db_path)

# look at the overall schema
DBI::dbReadTable(conn = conx, "sqlite_master")

# look at the tables in the database
DBI::dbListTables(conx)

# look at fields in table apps
DBI::dbListFields(conx, "apps")

# get more detailed information with a query
DBI::dbGetQuery(conx, 
  statement = "PRAGMA table_info('apps');"
  )

# disconnect from database
DBI::dbDisconnect(conx)

# Delete the test database and remove it from your working directory
unlink(db_path)

}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other database: 
\code{\link{shiny_db_populate}()}
}
\concept{database}
