% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinymgr_setup.R
\name{shinymgr_setup}
\alias{shinymgr_setup}
\title{Sets up a new *shinymanager* directory structure and database}
\usage{
shinymgr_setup(parentPath, demo = FALSE)
}
\arguments{
\item{parentPath}{Path to the parent directory that will house the 
*shinymgr* file system.  A folder called "shinymgr" will be created under 
this parent directory.  If desired, create an RStudio project associated
 with the "shinymgr" folder, enabling use of the renv package.}

\item{demo}{TRUE or FALSE. Should the demo modules and demo database be 
included?}
}
\value{
Returns a file structure, database, and master app called app.R
}
\description{
Create a new *shinymgr* directory structure, database, and 
master app.  If demo == TRUE,  the database includes sample data and sample 
modules are also provided.
}
\details{
shinymgr_setup is the primary function to use when starting your 
own  *shinymgr* project.  The function's has two arguments: parentPath 
is the path to a folder that will house the *shinymgr* project (a directory 
called "shinymgr").  The function will create the main directory,
plus 9 sub directories ("analyses", "data", "database", "tests",
"modules", "modules_app", modules_mgr","reports",  "www").  Directory 
definitions are provided below.  If demo = TRUE, these directories will be 
populated with sample modules and a sample database that can be used to 
explore the package's functionality.  Once you understand the general 
*shinymgr* framework, you can create as many *shinymgr* projects as you 
wish by setting demo = FALSE. 

The parentPath argument points to a directory that will house the main 
*shinymgr* directory,
plus  9 subdirectories, along with the main *shinymgr* master app.R 
(or server.R and ui.R) shiny scripts.  

Directories of *shinymgr* include:

analyses = stores previously run "app" results as RDS file.  
data - holds datasets (RData, csv) that are used by "apps".
database - holds the shinymgr sqlite database, named "shinymgr.sqlite".
modules - holds stand-alone modules that are combined into shinymgr "apps".
modules_mgr - holds modules that are used in the shinymgr main app framework.
modules_app - stores app modules; i.e., a series of modules that are linked 
into a tabbed workflow.
reports - holds Rmd files that call in previously run analyses to produce 
an Rmarkdown report.
tests - holds unit testing of modules to ensure everything works.
www - stores all images and css files that are rendered in shiny.
}
\section{More Info}{

The shinymgr_setup() function is described in the "shinymgr" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{

# ------------------------------------------------------------
# Set up an shinymgr framework in a parent directory 
# ------------------------------------------------------------

# set the directory path that will house the shinymgr project
parentPath <- tempdir()
shinyMgrPath <- paste0(parentPath, '/shinymgr')

# set up raw directories and fresh database
shinymgr_setup(parentPath, demo = FALSE)

# verify that the folder structure exists in your specified directory
list.dirs(
  path = shinyMgrPath, 
  full.names = FALSE, 
  recursive = TRUE)

# look at the files 
list.files(
  path = shinyMgrPath, 
  full.names = FALSE, 
  recursive = TRUE)
  
# Remove demo database
unlink(shinyMgrPath, recursive = TRUE)

}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
\code{\link{shiny_db_create}}
}
\concept{database}
\concept{shinymgr}
