% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cell_race}
\alias{cell_race}
\title{A CART classification tree tuned via racing}
\value{
An object with primary class \code{tune_race}.
}
\description{
This object has the results when a CART classification tree model was
tuned over the cost-complexity parameter using racing.
}
\details{
To reduce the object size, a smaller subset of the data were used.

The code used to produce this object:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  library(tidymodels)
  library(finetune)
  tidymodels_prefer()

  ctrl_rc <- control_race(save_pred = TRUE)

  # ------------------------------------------------------------------------------

  data(cells)

  set.seed(1)
  cells <-
    cells \%>\%
    select(-case) \%>\%
    sample_n(200)

  # ------------------------------------------------------------------------------

  set.seed(2)
  cell_rs <- vfold_cv(cells)

  # ------------------------------------------------------------------------------

  set.seed(3)
  cell_race <-
    decision_tree(cost_complexity = tune()) \%>\%
    set_mode("classification") \%>\%
    tune_race_anova(
      class ~ .,
      resamples = cell_rs,
      grid = tibble(cost_complexity = 10^seq(-2, -1, by = 0.2)),
      control = ctrl_rc
    )
}\if{html}{\out{</div>}}
}
\keyword{datasets}
