% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\name{getSeriesCurrentValue}
\alias{getSeriesCurrentValue}
\title{Time series current value}
\usage{
getSeriesCurrentValue(series)
}
\arguments{
\item{series}{A vector containing idSeries}
}
\value{
A data.frame containing the data series requested.
}
\description{
Recovers last value of the indicated time series (up to 100)
from \href{http://www.banxico.org.mx/SieInternet}{SIE}.
}
\details{
This function queries the last value of each series requested. This value corresponds to the last
one published by Banco de México.

The data series are queried throught the \href{https://www.banxico.org.mx/SieAPIRest}{SIE API}.
This API requieres that every request is identified by a token. The token can be requested
\href{https://www.banxico.org.mx/SieAPIRest/service/v1/token}{here}.
Once the query token has been obtained and prior to use any function from this Package,
the token must be set in the current query session, using the function \code{\link{setToken}}.
}
\examples{

\dontrun{
## You need a valid token to run the example
setToken(token)
idSeries <- c("SF43718","SF46410","SF46407")
seriesDataFrame <- getSeriesCurrentValue(idSeries)

serieDataFrame <- getSeriesCurrentValue("SF43718")
}

}
