% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getURL.R
\name{getURL}
\alias{getURL}
\title{Highlight the relevant genes for a specific pathway in its pathway diagram}
\usage{
getURL(yy, i)
}
\arguments{
\item{yy}{A sigora analysis result object (created by \code{sigora}).}

\item{i}{The rank position of the pathway of interest in summary_results.}
}
\value{
The URL of the pathway diagram, where the relevant genes from your
original query list are highlighted.
}
\description{
This function highlights the genes involved in the present GPS for a pathway
of interest in its diagram. Please note that this functionality is only
implemented for results of Reactome or KEGG based analyses.
}
\examples{

data('kegH')
set.seed(seed=12345)
a1<-genesFromRandomPathways(kegH,3,50)
## originally selected pathways:\cr
a1[["selectedPathways"]]
## what are the genes
a1[["genes"]]
## sigora's results with this input:\cr
sigoraRes <- sigora(GPSrepo =kegH, queryList = a1[["genes"]],level = 2)
## Diagram for the most significant result, where the genes from our list are highlighted in red:
getURL(sigoraRes,1)

}
\seealso{
\code{\link{sigora}}
}
\keyword{functions}
