% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_publish_bands.R
\name{publish_bands}
\alias{publish_bands}
\alias{publish_bands.geoserver}
\title{Publish Bands of a Raster to GeoServer}
\usage{
publish_bands(gso, raster, prefix, postfix, bands)

\method{publish_bands}{geoserver}(gso, raster, prefix = NULL, postfix = NULL, bands = NULL)
}
\arguments{
\item{gso}{An object of class `geoserver` containing GeoServer connection details.}

\item{raster}{A character string specifying the file path to the GeoTIFF raster file
to be uploaded.}

\item{prefix}{A string to prepend to each layer name. Default is `NULL`.}

\item{postfix}{A string to append to each layer name. Default is `NULL`.}

\item{bands}{A named integer vector, index of the bands to publish with layer names.
If it is `NULL`, which is the default value, all bands are published using the band
name as the layer name. If unnamed indices are provided, the band name is also used
as the layer name.}
}
\value{
An integer:
\itemize{
  \item \code{0} if the operation was successful or if the layer already exists.
  \item \code{1} if an error occurred.
}
}
\description{
Publishes bands of a multi-band GeoTIFF raster file as separate coverages
in a specified workspace on a GeoServer instance.
}
\examples{
\dontrun{
gso <- geoserver(
  url = "http://localhost:8080/geoserver",
  user = "admin",
  password = "geoserver",
  workspace = "sigugr_test"
)

source_tif <- system.file("extdata/sat.tif", package = "sigugr")

gso |>
  publish_bands(source_tif)
}
}
\seealso{
Other publish to GeoServer: 
\code{\link{geoserver}()},
\code{\link{publish_layer}()},
\code{\link{publish_layer_set}()},
\code{\link{publish_raster}()},
\code{\link{register_datastore_postgis}()}
}
\concept{publish to GeoServer}
