% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-stand-level.R
\name{silv_stand_lorey_height}
\alias{silv_stand_lorey_height}
\title{Calculates Lorey's Height}
\usage{
silv_stand_lorey_height(height, g, ntrees = NULL)
}
\arguments{
\item{height}{Numeric vector of heights}

\item{g}{Numeric vector of basal areas}

\item{ntrees}{Optional. Numeric vector of number of trees per hectare.
Use this argument when you have aggregated data by diametric classes (see details).}
}
\value{
A numeric vector
}
\description{
Tree's mean height weighted by basal area
}
\details{
The function calculates Lorey's mean height according to:

\deqn{h_L = \frac{\sum n_i g_i h_i}{\sum n_i g_i}}

When ntrees is not provided (i.e. \code{ntrees = NULL}) the formula is simply
the weighted mean of the provided heights and basal areas:

\deqn{h_L = \frac{\sum g_i h_i}{\sum g_i}}
}
\examples{
## Calculate Lorey's Height by plot and species
library(dplyr)
inventory_samples |>
  mutate(g = silv_tree_basal_area(diameter)) |>
  summarise(
    lh  = silv_stand_lorey_height(height, g),
    .by = c(plot_id, species)
  )
}
