% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inventory-summary.R
\name{silv_summary}
\alias{silv_summary}
\title{Calculates a bunch of forest metrics}
\usage{
silv_summary(
  data,
  diameter,
  height,
  plot_size,
  .groups = NULL,
  plot_shape = "circular",
  dmin = 7.5,
  dmax = NULL,
  class_length = 5,
  include_lowest = TRUE,
  which_h0 = "assman",
  which_spacing = "hart"
)
}
\arguments{
\item{data}{A tibble of inventory data}

\item{diameter}{A column with inventory diameters}

\item{height}{A column with inventory heights}

\item{plot_size}{The size of the plot. See \code{\link[=silv_density_ntrees_ha]{silv_density_ntrees_ha()}}}

\item{.groups}{A character vector with variables to group by (e.g. plot id, tree
species, etc)}

\item{plot_shape}{The shape of the sampling plot. Either \code{circular} or \code{rectangular}}

\item{dmin}{The minimum inventory diameter in centimeters}

\item{dmax}{The maximum inventory diameter in centimeters. Values that
are greater than \code{dmax} are included in the greatest class}

\item{class_length}{The length of the class in centimeters}

\item{include_lowest}{Logical. If TRUE (the default), the intervals are
\verb{[dim1, dim2)}. If FALSE, the intervals are \verb{(dim1, dim2]}

[dim1, dim2)\verb{. If FALSE, the intervals are }(dim1, dim2]: R:dim1,\%20dim2)\%60.\%20If\%20FALSE,\%20the\%20intervals\%20are\%20\%60(dim1,\%20dim2}

\item{which_h0}{The method to calculate the dominant height. See \code{\link[=silv_stand_dominant_height]{silv_stand_dominant_height()}}}

\item{which_spacing}{A character with the name of the index (either \code{hart} or \code{hart-brecking}).
See \code{\link[=silv_density_hart]{silv_density_hart()}}}
}
\value{
an S7 \code{Inventory} list with 2 \code{tibbles}
}
\description{
Summarize forest inventory data calculating most typical variables
}
\details{
The function calculates many inventory parameters and returns two tibbles:
\itemize{
\item \bold{dclass_metrics}: metrics summarized by .groups and diametric classes
\item \bold{group_metrics}: metrics summarized by .groups
}
}
\examples{
silv_summary(
  data      = inventory_samples,
  diameter  = diameter,
  height    = height,
  plot_size = 10,
  .groups   = c("plot_id", "species")
 )
}
