% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_STRmix_kit_settings.R
\name{read_STRmix_kit_settings}
\alias{read_STRmix_kit_settings}
\title{Read STRmix Kit Settings}
\usage{
read_STRmix_kit_settings(filename, stutters_dir, include_y_loci = FALSE)
}
\arguments{
\item{filename}{Character vector specifying the path to the XML file containing the profiling kit settings.}

\item{stutters_dir}{Character vector specifying the directory path where stutter settings files are located.}

\item{include_y_loci}{Should Y loci be included in the list of locus names? Default is \code{FALSE}.}
}
\value{
A list containing the following components:
\itemize{
\item locus_names. Character vector.
\item degradation_parameter_cap. Numeric.
\item c2_prior. Numeric of length two with shape and scale.
\item LSAE_variance_prior. Numeric of length one.
\item detection_threshold. Numeric vector (named) with Detection Thresholds. Defaults to 50 for each locus.
\item size_regression. Function, see \link{read_size_regression}.
\item stutter_model. A list representing the stutter model.
\item stutter_variability. A list representing the stutter variability.
}
}
\description{
Read STRmix kit settings from an XML file and associated stutter directory.
}
