% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_DualKc.R
\name{Model_DualKc}
\alias{Model_DualKc}
\title{Simulation of evapotranspiration using dual crop coefficient method}
\usage{
Model_DualKc(data, param)
}
\arguments{
\item{data}{A data box. Contains the daily data required by the model. You can refer to the function create_modelData()}

\item{param}{A list. Contains additional parameters.
list(Kini,Kmid,Kend,fw,rootDepth,Dei_start,Dri_start,FCe,WPe,Ze,REW,TAW,p,FCr,CR_param)}
}
\value{
A list for the model result including a data frame of daily model result ,a list of plots, A data frame of summary data
}
\description{
Simulation of evapotranspiration using dual crop coefficient method
}
\note{
The stages of data should include all four stages.
 If a crop has multiple growth cycles, each cycle should include all four stages.
}
\examples{
 library(simET)
 data("FIalfalfa")
 names(FIalfalfa)
 #--Model parameter
 Dparam_FI<-list(Kini=0.3,#Kcb for initial stage
               Kmid=1.15,#Kcb for mid-season stage
               Kend=1.1,#Kcb for late season stage
               DI=FALSE,#Is it drip irrigation?
               fw=1,# The fraction of the surface wetted
               rootDepth=1.2,#Maximum root depth
               Dei_start=0,#Initial depletion of evaporation layer
               Dri_start=35,#Initial depletion of root layer
               FCe=0.22,#Field capacity of evaporation layer
               WPe=0.15,#Wilting point of evaporation layer
               Ze=0.15,#Depth of the surface soil layer
               REW=6,#Readily evaporable water
               TAW=297,#Total available soil water of the root zone
               p=0.55,#Evapotranspiration depletion factor
               FCrmm=430,#Field capacity of root layer
               CR_param=c(430,-0.32,310,-0.16,-1.4,6.8,1.11,-0.98)
                 #Capillary rise model parameters
               )
 #--Run model
 Model_re_FI<-Model_DualKc(data = FIalfalfa,param = Dparam_FI)
 #--The Result data
 Model_re_FI$Result
 Model_re_FI$Plot
 #--The goodness Of Fit
 estimate_goodnessOfFit(Sim = Model_re_FI$Result$Sim_SoilWater,
                         Obs = Model_re_FI$Result$SoilWater)
}
