% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vnbinom}
\alias{vnbinom}
\title{Variate Generation for Negative Binomial Distribution}
\usage{
vnbinom(n, size, prob, mu, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{size}{target for number of successful trials, or dispersion
parameter (the shape parameter of the gamma mixing
distribution).  Must be strictly positive, need not be
integer.}

\item{prob}{Probability of success in each trial;  '0 < prob <= 1'}

\item{mu}{alternative parameterization via mean}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via
\code{\link[=qnbinom]{stats::qnbinom}};
otherwise, an integer in 1:25 indicates the \code{\link[rstream]{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qnbinom]{stats::qnbinom}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[rstream]{rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of negative binomial random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Negative Binomial Distribution
}
\details{
Generates random variates from the negative binomial distribution.

Negative Binomial variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[rstream]{rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qnbinom]{stats::qnbinom}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vnbinom} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

The negative binomial distribution with \code{size} \eqn{= n} and
\code{prob} \eqn{= p} has density

\if{html}{\out{<div class="sourceCode">}}\preformatted{      \deqn{p(x) = \frac{\Gamma(x+n)}{\Gamma(n) \ x!} p^n (1-p)^x}{%
                p(x) = Gamma(x+n)/(Gamma(n) x!) p^n (1-p)^x}
}\if{html}{\out{</div>}}

for \eqn{x = 0, 1, 2, \ldots, n > 0} and \eqn{0 < p \leq 1}. This represents the
number of failures which occur in a sequence of Bernoulli trials before a
target number of successes is reached.

The mean is \eqn{\mu = n(1 - p)/p} and variance \eqn{n(1 - p)/p^2}
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qnbinom
 vnbinom(3, size = 10, mu = 10)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qnbinom
 vnbinom(3, 10, 0.25, stream = 1)
 vnbinom(3, 10, 0.25, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qnbinom
 vnbinom(1, 10, 0.25, stream = 1)
 vnbinom(1, 10, 0.25, stream = 2)
 vnbinom(1, 10, 0.25, stream = 1)
 vnbinom(1, 10, 0.25, stream = 2)
 vnbinom(1, 10, 0.25, stream = 1)
 vnbinom(1, 10, 0.25, stream = 2)

 set.seed(8675309)
 variates <- vnbinom(100, 10, 0.25, stream = 1)
 set.seed(8675309)
 variates <- vnbinom(100, 10, 0.25, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link[rstream]{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=rnbinom]{stats::rnbinom}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
