% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genTrueItems.R
\name{genTrueItems}
\alias{genTrueItems}
\title{Generate true item parameters for NEAT design}
\usage{
genTrueItems(C, J, U, num.forms, min.a = 0.5, max.a = 2, mu.b = 0,
  sd.b = 1, anchor.type = "internal", output = "list",
  linkage.plan = NULL, ...)
}
\arguments{
\item{C}{number of common items between two forms}

\item{J}{number of items per form}

\item{U}{number of unique items per form (only valid for external anchor)}

\item{num.forms}{number of forms}

\item{min.a}{Lower bound for the (uniform) distribution of item
discrimination parameter}

\item{max.a}{Upper bound for the (uniform) distribution of item
discrimination parameter}

\item{mu.b}{Mean of (normally-distributed) item difficulty parameter}

\item{sd.b}{Standard deviation of (normally-distributed) item difficulty
parameter}

\item{anchor.type}{type of anchor item set ("internal" or "external")}

\item{output}{type of output; "list" gives a list of used items per form,
"matrix" gives a joint matrix (data.frame).}

\item{linkage.plan}{matrix containing linkage plan}

\item{...}{extra parameters to be passed to genItemBankInt() or
genItemBankExt()}
}
\value{
List of true item parameters per form
}
\description{
Creates true item parameters for a 2-parameters IRT model for
  posterior generation of item responses, IRT implementation and equating.
  Compatible with the common-item, non-equivalent group design (see Kolen et.
  al. 2004).
}
\author{
Waldir Leoncio
}
