% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_int.R
\name{mle_int}
\alias{mle_int}
\title{Interval-Censored Maximum Likelihood Estimation}
\usage{
mle_int(left, right, dist)
}
\arguments{
\item{left}{Left bounds of censoring intervals}

\item{right}{Right bounds of censoring intervals}

\item{dist}{Distribution name (e.g. "weibull", "loglogistic", "EMV")}
}
\value{
A list containing estimates, standard errors, log-likelihood, and convergence status
}
\description{
Estimates distribution parameters by maximizing the interval-censored likelihood.
}
\examples{
# Simulate data from a log-logistic distribution
set.seed(123)
data <- simIC(n = 100, dist = "loglogistic", shape = 1.5, scale = 5, width = 2,
              study_start = 1, study_end = 8, uncensored_tol = 0.1)
# Fit the model
fit <- mle_int(left = data$left, right = data$right, dist = "loglogistic")
print(fit$estimates)
print(fit$logLik)
print(fit$converged)
}
