% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalFunctions.R
\name{PwcOSInt}
\alias{PwcOSInt}
\title{Helper Function of \code{PWCsurvOS()}}
\usage{
PwcOSInt(x, t, h01, h02, h12, pw01, pw02, pw12)
}
\arguments{
\item{x}{(\code{numeric})\cr  variable of integration.}

\item{t}{(\code{numeric})\cr study time-points.}

\item{h01}{(\verb{numeric vector})\cr constant transition hazards for 0 to 1 transition.}

\item{h02}{(\verb{numeric vector})\cr constant transition hazards for 0 to 2 transition.}

\item{h12}{(\verb{numeric vector})\cr constant transition hazards for 1 to 2 transition.}

\item{pw01}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h01}.}

\item{pw02}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h02}.}

\item{pw12}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h12}.}
}
\value{
Numeric results of the integrand used to calculate
the OS survival function for piecewise constant transition hazards, see  \code{PWCsurvOS}.
}
\description{
Helper Function of \code{PWCsurvOS()}
}
\keyword{internal}
