% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effCont.R
\name{eff.cont-class}
\alias{eff.cont-class}
\alias{effCont_new}
\title{Class \code{eff.cont}}
\usage{
effCont_new(mean, var, df, x = NULL)
}
\arguments{
\item{mean}{the expected value of the distibution.}

\item{var}{the variance of the distribution.}

\item{df}{the effective degrees of freedom of the distribution.}

\item{x}{the sample of effectiveness scores used to fit the distribution. Defaults to
\code{NULL}.}
}
\value{
an object of class \code{eff.cont}, with the following components:
\tabular{rl}{
  \code{mean} \tab the expected value. \cr
  \code{var} \tab the variance. \cr
  \code{df} \tab the degrees of freedom (effective number of parameters) for
    \link[=effSelect]{model selection}. \cr
  \code{data} \tab the sample data used to fit the distribution, or \code{NULL} if none. \cr
  \code{model} \tab a list with the family-specific data. \cr
}
}
\description{
This is the base S3 class for all continuous effectiveness distributions, which is itself a
subclass of \code{eff}. Function \code{effCont_new} is the constructor of the class.
}
\details{
A new distribution family is expected to build new objects through this constructor, and they
must implement methods \code{\link{deff}}, \code{\link{peff}}, \code{\link{qeff}} and
\code{\link{reff}}.
}
\seealso{
\code{\link{effCont}} for a list of currently implemented distribution families,
  \code{\link{effContFit}} to fit distributions, and \code{\link{effCont-helper}} for helper
  functions.

  For discrete distributions, see \code{\link[=eff.disc-class]{eff.disc}}.
}
