% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effCont_bks.R
\name{effCont_bks}
\alias{effCont_bks}
\title{Continuous Effectiveness as Beta Kernel-smoothed Distribution.}
\usage{
effCont_bks(x)
}
\arguments{
\item{x}{a sample of effectiveness scores between 0 and 1.}
}
\value{
an object of class \code{eff.cont.bks}, which inherits from
  \code{\link[=eff.cont-class]{eff.cont}}.
}
\description{
Fits a bounded kernel-smoothed distribution to the given sample of scores. In particular, the
beta kernel by Chen (1999) is used, as in \code{\link[bde]{Chen99Kernel}}.
}
\examples{
e <- effCont_bks(web2010ap[,1])
c(e$mean, e$var)
plot(e, plot.data = TRUE)
}
\references{
S.X. Chen (1999). Beta kernel estimators for density functions. Computational
  Statistics & Data Analysis, 31, 131-145.
}
\seealso{
\code{\link{deff}}, \code{\link{peff}}, \code{\link{qeff}} and \code{\link{reff}}.
}
