% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfa_load_shareprices.R
\name{sfa_load_shareprices}
\alias{sfa_load_shareprices}
\title{Load share prices}
\usage{
sfa_load_shareprices(
  ticker = NULL,
  id = NULL,
  start = NULL,
  end = NULL,
  ratios = FALSE,
  asreported = FALSE,
  api_key = getOption("sfa_api_key"),
  cache_dir = getOption("sfa_cache_dir")
)
}
\arguments{
\item{ticker}{\link{integer} Ticker of the companies of interest.}

\item{id}{\link{integer} 'SimFin' IDs of the companies of interest. Any
\code{id} will be internally translated to the respective \code{ticker}. This
reduces the number of queries in case you query the same company via
\code{ticker} \emph{and} \code{id}.}

\item{start}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending AFTER the specified
date.}

\item{end}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending BEFORE the specified
date.}

\item{ratios}{\link{logical} If \code{TRUE}, additional ratios and derived metrics are included.}

\item{asreported}{\link{logical} If \code{TRUE}, retrieves the as-reported (not restated) data.}

\item{api_key}{\link{character} Your 'SimFin' API key. It's recommended to set
the API key globally using \link{sfa_set_api_key}.}

\item{cache_dir}{\link{character} Your cache directory. It's recommended to set
the cache directory globally using \link{sfa_set_cache_dir}.}
}
\value{
\link[data.table:data.table]{data.table::data.table} with share price data.
}
\description{
Retrieve share price data and ratios.
}
