% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{analyze.simstudy.logistic}
\alias{analyze.simstudy.logistic}
\title{Analyze Simulated Logistic Regression Models}
\usage{
analyze.simstudy.logistic(
  the.coefs,
  summary.stats,
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  coef.name = "Coefficient",
  estimate.name = "Estimate",
  logistic.p.name = "Pr(>|z|)"
)
}
\arguments{
\item{the.coefs}{A data frame or data.table containing the summary table of estimated
coefficients from repeated logistic regression models. It should be structured like the output
of \code{simitation::sim.statistics.logistic$the.coefs()}.}

\item{summary.stats}{A data.frame or data.table object of the summary statistics of repeated logistic regression models.  Structure is in the form returned by the function simitation::sim.statistics.logistic$summary.stats().}

\item{conf.level}{A numeric value between 0 and 1 representing the confidence level (1 - significance level).}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}

\item{coef.name}{A character value specifying the column of the.coefs that contains the names of the input variables of the logistic regression model.}

\item{estimate.name}{A character value specifying the column of the.coefs that contains the estimated coefficients of the logistic regression model.}

\item{logistic.p.name}{A character value specifying the column of the.coefs that contains the p-values for the tests of the estimated coefficients of the logistic regression model.}
}
\value{
A list with several summary statistics for the logistic regression model.
}
\description{
This function analyzes the results of simulated logistic regression models, providing
various summary statistics about the model coefficients, fit, and other aspects.
}
\examples{
step.age <- "Age ~ N(45, 10)"
step.female <- "Female ~ binary(0.53)"
step.health.percentile <- "Health.Percentile ~ U(0,100)"
step.exercise.sessions <- "Exercise.Sessions ~ Poisson(2)"
step.diet <- "Diet ~ sample(('Light', 'Moderate', 'Heavy'),
(0.2, 0.45, 0.35))"
step.healthy.lifestyle <- "Healthy.Lifestyle ~
logistic(log(0.45) - 0.1 * (Age -45) + 0.05 * Female +
0.01 * Health.Percentile + 0.5 * Exercise.Sessions - 0.1 *
(Diet == 'Moderate') - 0.4 * (Diet == 'Heavy'))"

step.weight <- "Weight ~ lm(150 - 15 * Female + 0.5 * Age - 0.1 *
Health.Percentile - 0.2 * Exercise.Sessions  + 5 * (Diet == 'Moderate') +
15 * (Diet == 'Heavy') - 2 * Healthy.Lifestyle + N(0, 10))"

the.steps <- c(step.age, step.female, step.health.percentile,
step.exercise.sessions, step.diet, step.healthy.lifestyle, step.weight)

simdat.multivariate <- simulation.steps(the.steps = the.steps,
 n = 50, num.experiments = 2, experiment.name = "sim", seed = 41)


stats.logistic <- sim.statistics.logistic(simdat =
simdat.multivariate, the.formula =
Healthy.Lifestyle ~ Age + Female + Health.Percentile + Exercise.Sessions,
grouping.variables = "sim")


analysis.logistic <- analyze.simstudy.logistic(the.coefs =
stats.logistic$the.coefs, summary.stats =
stats.logistic$summary.stats,
conf.level = 0.95, the.quantiles = c(0.1, 0.9))

}
