% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{analyze.simstudy.prop2}
\alias{analyze.simstudy.prop2}
\title{analyze.simstudy.prop2}
\usage{
analyze.simstudy.prop2(
  test.statistics.prop2,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975)
)
}
\arguments{
\item{test.statistics.prop2}{Summary information for fitting two-sample tests of proportions.  Structure is in the form returned by the function simitation::sim.prop2.test().}

\item{alternative}{See help(prop.test).}

\item{conf.level}{See help(prop.test).}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}
}
\value{
A list containing the following elements:
\itemize{
  \item estimate.summary: Summary statistics for the estimate.
  \item stat.summary: Summary statistics for the test statistic.
  \item p.value.summary: Data frame with proportions of tests that rejected and did not reject the null hypothesis.
  \item df.summary: Summary statistics for the degrees of freedom.
  \item ci.range.summary: Summary statistics for the confidence interval range.
  \item ci.proportion.above.null.summary: Summary statistics for the proportion of the upper confidence limit above the null value.
  \item ci.proportion.below.null.summary: Summary statistics for the proportion of the lower confidence limit below the null value.
  \item ci.limit.summary: Summary statistics for either the lower or upper confidence limit, depending on the specified alternative.
}
}
\description{
analyze.simstudy.prop2
}
\examples{

simdat.prop2 <- sim.prop2(nx = 30, ny = 40, px = 0.5,
 py = 0.55, num.experiments = 2, experiment.name = "sim",
 group.name = "treatment", x.value = "group_1", y.value = "group_2",
 value.name = "correct_answer", seed = 3)

test.statistics.prop2 <- sim.prop2.test(simdat.prop2 = simdat.prop2,
p = NULL, alternative = "less", conf.level = 0.95, correct = TRUE,
experiment.name = "sim", group.name = "treatment", x.value = "group_1",
y.value = "group_2", value.name = "correct_answer")

analysis.prop2 <- analyze.simstudy.prop2(test.statistics.prop2 =
test.statistics.prop2, alternative = "less", conf.level = 0.95,
the.quantiles = c(0.025, 0.1, 0.9, 0.975))
}
