% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{simstudy.t}
\alias{simstudy.t}
\title{simstudy.t}
\usage{
simstudy.t(
  n,
  mean = 0,
  sd = 1,
  num.experiments = 1,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  experiment.name = "experiment",
  value.name = "x",
  seed = 7261,
  vstr = 3.6
)
}
\arguments{
\item{n}{A numeric value for the number of observations in each experiment.}

\item{mean}{A numeric value for the expected value of the data to be simulated.}

\item{sd}{A numeric value for the standard deviation of the data to be simulated.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{alternative}{See help(t.test).}

\item{mu}{See help(t.test)}

\item{conf.level}{See help(t.test)}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{value.name}{A character value providing the name for the simulated values.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A list containing the following components:

\itemize{
  \item{\code{simdat.t}}{A data frame of the simulated t-distributed data.}
  \item{\code{test.statistics.t}}{A data frame containing the results of the t-tests.}
  \item{\code{sim.analysis.t}}{A data frame containing the analysis of the simulated study for t-tests.}
}
}
\description{
simstudy.t
}
\examples{
study.t <- simstudy.t(n = 25, mean = 0.3, sd = 1,
num.experiments = 2, alternative = "greater", mu = 0,
conf.level = 0.95, the.quantiles = c(0.025, 0.975),
experiment.name = "experiment",value.name = "x", seed = 817)
}
