% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{edges}
\alias{edges}
\title{Edges of a graph}
\usage{
edges(graph)
}
\arguments{
\item{graph}{The graph}
}
\value{
Data frame of edge data and metadata. The tail and head
  vertices are in the fist two columns. The rest of the columns are
  metadata.
}
\description{
Edges of a graph
}
\examples{
bridges <- graph(list(
  "Altstadt-Loebenicht" = c(
    "Kneiphof",
    "Kneiphof",
    "Lomse"
  ),
  "Kneiphof" = c(
    "Altstadt-Loebenicht",
    "Altstadt-Loebenicht",
    "Vorstadt-Haberberg",
    "Vorstadt-Haberberg",
    "Lomse"
  ),
  "Vorstadt-Haberberg" = c(
    "Kneiphof",
    "Kneiphof",
    "Lomse"
  ),
  "Lomse" = c(
    "Altstadt-Loebenicht",
    "Kneiphof",
    "Vorstadt-Haberberg"
  )
))
edges(bridges)
}
\seealso{
Other simple queries: 
\code{\link{adjacent_vertices}()},
\code{\link{order}()},
\code{\link{vertices}()}
}
\concept{simple queries}
