% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_figure.R
\name{md_figure}
\alias{md_figure}
\title{Generate a figure and generate the markdown to include the figure}
\usage{
md_figure(
  expr,
  name,
  caption = "",
  id = "",
  dir = file.path(Sys.getenv("MDOUTDIR", "."), "figures"),
  device = c("png", "pdf"),
  ...,
  as_character = FALSE,
  echo = FALSE,
  results = FALSE,
  formatter = getOption("md_formatter", default = format_traditional),
  capture_warnings = FALSE,
  capture_messages = results,
  muffle_warnings = FALSE,
  muffle_messages = TRUE
)
}
\arguments{
\item{expr}{the expressions to evaluate. Will generally contain plotting
commands. The expressions are evaluated in the global environment.}

\item{name}{the name of the figure.}

\item{caption}{text of the caption. When omitted no caption is added to the
figure.}

\item{id}{id of the figure. When omitted or equal to NULL or an empty
character, no id is added to the figure.}

\item{dir}{name of the directory in which to store the file.}

\item{device}{the graphics device to use for creating the image.}

\item{...}{passed on to the graphics device.}

\item{as_character}{return the figure as a character vector. If \code{FALSE}
the figure will be written to the standard output.}

\item{echo}{the code in \code{code} is repeated in the output.}

\item{results}{include the results of running the code in the output. The
output of code that explicitly writes to standard output is always
included.}

\item{formatter}{function that will format the R-code and resulting output
(if requested). See \code{\link{format_traditional}} for possible options.}

\item{capture_warnings}{include warnings in the output.}

\item{capture_messages}{include messages in the output.}

\item{muffle_warnings}{do not show warnings in the console.}

\item{muffle_messages}{do not show messages in the console.}
}
\value{
When \code{as_character = FALSE} a character vector with the markdown needed
to include the generated figure in a markdown file is returned. Otherwise,
nothing is returned; the markdown is written to the console.
}
\description{
Will evaluate the expressions in \code{expr} and capture the output on the
given plotting device in the given file. It will then generate the markdown
needed to include that figure in a markdown document.
}
\details{
The image is stored in the file \code{dir/name.device}.
}
