% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simultaneous.R
\name{fit.3fkmeans}
\alias{fit.3fkmeans}
\alias{fit.3fkmeans,simultaneous-method}
\title{3FKMeans Model}
\usage{
fit.3fkmeans(model, X_i_jk, full_tensor_shape, reduced_tensor_shape)

\S4method{fit.3fkmeans}{simultaneous}(model, X_i_jk, full_tensor_shape, reduced_tensor_shape)
}
\arguments{
\item{model}{Initialized simultaneous model.}

\item{X_i_jk}{Matricized tensor along mode-1 (I objects).}

\item{full_tensor_shape}{Dimensions of the tensor in full-space.}

\item{reduced_tensor_shape}{Dimensions of tensor in the reduced-space.}
}
\value{
Output attributes accessible via the '@' operator.
\itemize{
   \item U_i_g0 - Initial object membership function matrix
   \item B_j_q0 - Initial factor/component matrix for the variables
   \item C_k_r0 - Initial factor/component matrix for the occasions
   \item U_i_g - Final/updated object membership function matrix
   \item B_j_q - Final/updated factor/component matrix for the variables
   \item C_k_r - Final/updated factor/component matrix for the occasions
   \item Y_g_qr - Derived centroids in the reduced space (data matrix)
   \item X_i_jk_scaled - Standardized dataset matrix
   \item BestTimeElapsed - Execution time for the best iterate
   \item BestLoop - Loop that obtained the best iterate
   \item BestIteration - Iteration yielding the best results
   \item Converged - Flag to check if algorithm converged for the K-means
   \item nConverges - Number of loops that converged for the K-means
   \item TSS_full - Total deviance in the full-space
   \item BSS_full - Between deviance in the reduced-space
   \item RSS_full - Residual deviance in the reduced-space
   \item PF_full - PseudoF in the full-space
   \item TSS_reduced - Total deviance in the reduced-space
   \item BSS_reduced - Between deviance in the reduced-space
   \item RSS_reduced - Residual deviance in the reduced-space
   \item PF_reduced - PseudoF in the reduced-space
   \item PF - Weighted PseudoF score
   \item Labels - Object cluster assignments
   \item Fs - Objective function values for the KM best iterate
   \item Enorm - Average l2 norm of the residual norm.
}
}
\description{
Implements simultaneous version of TWFCTA
}
\details{
{
   The procedure performs simultaneously the sequential TWFCTA model.
   The model finds B_j_q and C_k_r such that the within-clusters deviance of
   the component scores is minimized.
}
}
\examples{
X_i_jk = generate_dataset()$X_i_jk
model = simultaneous()
tfkmeans = fit.3fkmeans(model, X_i_jk, c(8,5,4), c(3,3,2))

}
\references{
\insertRef{tucker1966}{simuclustfactor}
\insertRef{3FKMeans}{simuclustfactor}
\insertRef{VichiRocciKiers}{simuclustfactor}
}
