% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_all.R
\name{sim_all}
\alias{sim_all}
\title{Is a wrapper for sim_choice executing the simulation over all designs stored in a specific folder
update}
\usage{
sim_all(
  nosim = 2,
  resps,
  designtype = NULL,
  destype = NULL,
  designpath,
  u,
  bcoeff,
  decisiongroups = c(0, 1),
  manipulations = list(),
  estimate = TRUE,
  chunks = 1,
  utility_transform_type = "simple",
  reshape_type = "auto",
  mode = c("parallel", "sequential"),
  preprocess_function = NULL,
  savefile = NULL
)
}
\arguments{
\item{nosim}{Number of runs or simulations. For testing use 2 but once you go serious, use at least 200, for better results use 2000.}

\item{resps}{Number of respondents you want to simulate}

\item{designtype}{Is it a design created with ngene, spdesign or idefix. use 'ngene', 'spdesign' or 'idefix. Ngene designs should be stored as the standard .ngd output. spdesign should be the spdesign object stored as an RDS file. Idefix objects should also be stored as an RDS file. If designtype is not specified, I try to guess what it is. This is especially helpful if you want to carry out a simulation for both spdesign designs and ngene designs at the same time.}

\item{destype}{Deprecated. Use designtype instead.}

\item{designpath}{The path to the folder where the designs are stored. For example "c:/myfancydec/Designs"}

\item{u}{A list with utility functions. The list can incorporate as many decision rule groups as you want. However, each group must be in a list in this list. If you just use one group (the normal),  this  group still  has to be in a list in  the u list. As a convention name beta coefficients starting with a lower case "b"}

\item{bcoeff}{List of initial coefficients for the utility function. List content/length can vary based on application. I ideally begins (but does not have to) with b and need be the same as those entered in the utility functions}

\item{decisiongroups}{A vector showing how decision groups are numerically distributed}

\item{manipulations}{A variable to alter terms of the utility functions examples may be applying a factor or applying changes to terms selectively for different groups}

\item{estimate}{If TRUE models will be estimated. If false only a dataset will be simulated. Default is TRUE}

\item{chunks}{The number of chunks determines how often results should be stored on disk as a safety measure to not loose simulations if models have already been estimated. For example, if no_sim is 100 and chunks = 2, the data will be saved on disk after 50 and after 100 runs.}

\item{utility_transform_type}{How the utility function you entered is transformed to the utility function required for mixl. You can use the classic way (simple) where parameters have to start with "b" and variables with "alt" or the more flexible (but potentially error prone) way (exact) where parameters and variables are matched exactly what how the are called in the dataset and in the bcoeff list. Default is "simple". In the long run, simple will be deleted, as exact should be downwards compatible.}

\item{reshape_type}{Must be "auto", "stats" to use the reshape from the stats package or tidyr to use pivot longer. Default is auto and should not bother you. Only change it once you face an error at this position and you may be lucky that it works then.}

\item{mode}{Set to "parallel" if parts should be run in parallel mode}

\item{preprocess_function}{= NULL You can supply a function that reads in external data (e.g. GIS coordinates) that will be merged with the simulated dataset. Make sure the the function outputs a data.frame that has a variable called ID which is used for matching.}

\item{savefile}{Indicate a path if you want to store the results after each design simulation locally. This is useful in case you fear that your computer crashes}
}
\value{
A list, with all information on the simulation. This list an be easily processed by the user and in the rmarkdown template.
}
\description{
Is a wrapper for sim_choice executing the simulation over all designs stored in a specific folder
update
}
\examples{
library(rlang)
designpath <- system.file("extdata", "SE_DRIVE", package = "simulateDCE")
resps <- 120 # number of respondents
nosim <- 2 # number of simulations to run (about 500 is minimum)

decisiongroups <- c(0, 0.7, 1)

# pass beta coefficients as a list
bcoeff <- list(
  b.preis = -0.01,
  b.lade = -0.07,
  b.warte = 0.02
)

manipulations <- list(
  alt1.x2 = expr(alt1.x2 / 10),
  alt1.x3 = expr(alt1.x3 / 10),
  alt2.x2 = expr(alt2.x2 / 10),
  alt2.x3 = expr(alt2.x3 / 10)
)


# place your utility functions here
ul <- list(
  u1 =

    list(
      v1 = V.1 ~ b.preis * alt1.x1 + b.lade * alt1.x2 + b.warte * alt1.x3,
      v2 = V.2 ~ b.preis * alt2.x1 + b.lade * alt2.x2 + b.warte * alt2.x3
    ),
  u2 = list(
    v1 = V.1 ~ b.preis * alt1.x1,
    v2 = V.2 ~ b.preis * alt2.x1
  )
)


sedrive <- sim_all(
  nosim = nosim,
  resps = resps,
  designpath = designpath,
  u = ul,
  bcoeff = bcoeff,
  decisiongroups = decisiongroups,
  manipulations = manipulations,
  utility_transform_type = "exact",
  mode = "sequential",
  estimate=FALSE
)

}
