% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_choice.R
\name{sim_choice}
\alias{sim_choice}
\title{Simulate and estimate choices}
\usage{
sim_choice(
  designfile,
  no_sim = 10,
  respondents = 330,
  u,
  designtype = NULL,
  destype = NULL,
  bcoeff,
  decisiongroups = c(0, 1),
  manipulations = list(),
  estimate,
  chunks = 1,
  utility_transform_type = "simple",
  mode = c("parallel", "sequential"),
  preprocess_function = NULL,
  savefile = NULL
)
}
\arguments{
\item{designfile}{path to a file containing a design.}

\item{no_sim}{Number of runs i.e. how often do you want the simulation to be repeated}

\item{respondents}{Number of respondents. How many respondents do you want to simulate in each run.}

\item{u}{A list with utility functions. The list can incorporate as many decision rule groups as you want. However, each group must be in a list in this list. If you just use one group (the normal),  this  group still  has to be in a list in  the u list. As a convention name beta coefficients starting with a lower case "b"}

\item{designtype}{Is it a design created with ngene, spdesign or idefix. use 'ngene', 'spdesign' or 'idefix. Ngene designs should be stored as the standard .ngd output. spdesign should be the spdesign object stored as an RDS file. Idefix objects should also be stored as an RDS file. If designtype is not specified, I try to guess what it is. This is especially helpful if you want to carry out a simulation for both spdesign designs and ngene designs at the same time.}

\item{destype}{Deprecated. Use designtype instead.}

\item{bcoeff}{List of initial coefficients for the utility function. List content/length can vary based on application. I ideally begins (but does not have to) with b and need be the same as those entered in the utility functions}

\item{decisiongroups}{A vector showing how decision groups are numerically distributed}

\item{manipulations}{A variable to alter terms of the utility functions examples may be applying a factor or applying changes to terms selectively for different groups}

\item{estimate}{If TRUE models will be estimated. If false only a dataset will be simulated. Default is TRUE}

\item{chunks}{The number of chunks determines how often results should be stored on disk as a safety measure to not loose simulations if models have already been estimated. For example, if no_sim is 100 and chunks = 2, the data will be saved on disk after 50 and after 100 runs.}

\item{utility_transform_type}{How the utility function you entered is transformed to the utility function required for mixl. You can use the classic way (simple) where parameters have to start with "b" and variables with "alt" or the more flexible (but potentially error prone) way (exact) where parameters and variables are matched exactly what how the are called in the dataset and in the bcoeff list. Default is "simple". In the long run, simple will be deleted, as exact should be downwards compatible.}

\item{mode}{Set to "parallel" if parts should be run in parallel mode}

\item{preprocess_function}{= NULL You can supply a function that reads in external data (e.g. GIS coordinates) that will be merged with the simulated dataset. Make sure the the function outputs a data.frame that has a variable called ID which is used for matching.}

\item{savefile}{Indicate a path if you want to store the results after each design simulation locally. This is useful in case you fear that your computer crashes}
}
\value{
a list with all information on the run
}
\description{
Simulate and estimate choices
}
\examples{
bcoeff <- list(
  basc = -1.2,
  basc2 = -1.4,
  baction = 0.1,
  badvisory = 0.4,
  bpartnertest = 0.3,
  bcomp = 0.02
)
ul <- list(
  u1 =
    list(
     #' # model specification ----------------------------------------------
v1 <- V.1 ~ basc +
  baction      * alt1.b +
  badvisory    * alt1.c +
  bpartnertest * alt1.d +
  bcomp        * alt1.p,

v2 <- V.2 ~ basc2 +
  baction      * alt2.b +
  badvisory    * alt2.c +
  bpartnertest * alt2.d +
  bcomp        * alt2.p,
 v3 <- V.3 ~ 0
    )
)

sim_choice(
  designfile = system.file("extdata", "agora", "altscf_eff.ngd", package = "simulateDCE"),
  no_sim = 2,
  respondents = 144,
  u = ul,
  bcoeff = bcoeff,
  estimate = FALSE
)

}
