% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_sinar.R
\name{teo_V}
\alias{teo_V}
\title{Compute the value of matrix V using the coefficients.}
\usage{
teo_V(a10, a01, a11, mu_e, s2_e)
}
\arguments{
\item{a10}{is the parameter in the equation \eqn{X[i, j]a_{10}X[i - 1, j] +
a_{01}X[i, j - 1] + a_{11}X[i - 1, j - 1] + \epsilon_{i,j}}}

\item{a01}{is the parameter in the equation \eqn{X[i, j]a_{10}X[i - 1, j] +
a_{01}X[i, j - 1] + a_{11}X[i - 1, j - 1] + \epsilon_{i,j}}}

\item{a11}{is the parameter in the equation \eqn{X[i, j]a_{10}X[i - 1, j] +
a_{01}X[i, j - 1] + a_{11}X[i - 1, j - 1] + \epsilon_{i,j}}}

\item{mu_e}{is the mean of the innovations \eqn{\epsilon_{i,j}}}

\item{s2_e}{is the standar deviation of the innovations \eqn{\epsilon_{i,j}}}
}
\value{
The matrix V estimated empirically.
}
\description{
\code{V} is the theoretical matrix from Klimko-Nelson for the SINAR(1,1)
model. Basically, we know
\deqn{\sqrt{n}(\hat{a}_{10} - a_{10}, \hat{a}_{01} - a_{01}, \hat{a}_{11} -
 a_{11}, \hat{\mu}_\epsilon - \mu_\epsilon)^\top \sim MNV(0, \Sigma)}
where
\deqn{\Sigma = V^{-1}W V^{-1}.}
For more details, check Klimko and Nelson (1978).
}
\examples{

n_row <- 20
n_col <- 50
a10 <- 0.2
a01 <- 0.2
a11 <-  0.5
l <- 1 # mean and variance for poison innovations

teo_V(a10, a01, a11, l, sqrt(l))
}
