% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sigaa.R
\name{read_sigaa}
\alias{read_sigaa}
\title{Read Sigaa files}
\usage{
read_sigaa(path = "", start = NULL)
}
\arguments{
\item{path}{The Sigaa file's path.}

\item{start}{A character with the date to start the comparison. The default is the minimum
value found in the data. The date has to be in this format: "yyyy.semester".
Ex.: "2019.1" or "2019.2".}
}
\value{
A data frame.
}
\description{
This function reads partial and complete Sigaa datasets. These two formats can perform the
comparison, but the partial doesn't have information about "Campus" and "Cota". See Details
if you need help where to download the Sigaa data.
}
\details{
To download the partial Sigaa's data, go to your proper account on Sigaa and
follow:
\itemize{
\item Access the panel "Consultas" inside Sigaa module.
\item Generate the report "Consulta geral discentes".
\item Select the check box "Trazer informações em forma de relatório" e "Gerar csv".
\item Select the filter "Campus" and other filters you desire.
\item Click on "Buscar" and download the file.
}

Be sure that your data has the variables: "Matricula", "Nome", "Status,
"Curso" and "CPF".

For the complete dataset, you have to download directly from the Sigaa database. Be sure
that your data has the variables: "Matricula", "Nome", "Situacao Matricula", "Curso",
"Cpf", "Instituicao", "ano_ingresso", "semestre_ingresso" and "Cota".
}
\examples{
 
# this dataset is not a real one. It is just for test purpose.
sigaa <- read_sigaa(system.file("extdata/examples/sigaa",
                                package = "sistec"))

sigaa
}
