% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_get_data.R
\name{sits_get_data.data.frame}
\alias{sits_get_data.data.frame}
\title{Get time series using sits objects}
\usage{
\method{sits_get_data}{data.frame}(
  cube,
  samples,
  ...,
  start_date = NULL,
  end_date = NULL,
  bands = NULL,
  impute_fn = impute_linear(),
  label = "NoClass",
  crs = "EPSG:4326",
  multicores = 2,
  progress = FALSE
)
}
\arguments{
\item{cube}{Data cube from where data is to be retrieved.
(tibble of class "raster_cube").}

\item{samples}{A data.frame with mandatory columns \code{longitude},
and \code{latitude}, and optional columns
\code{start_date}, \code{end_date}, \code{label}.}

\item{...}{Specific parameters for specific cases.}

\item{start_date}{Start of the interval for the time series - optional
(Date in "YYYY-MM-DD" format).}

\item{end_date}{End of the interval for the time series - optional
(Date in "YYYY-MM-DD" format).}

\item{bands}{Bands to be retrieved - optional.}

\item{impute_fn}{Imputation function to remove NA.}

\item{label}{Label to be assigned to all time series if
column \code{label} is not provided in the
data.frame.}

\item{crs}{A character with the samples crs.
Default is "EPSG:4326".}

\item{multicores}{Number of threads to process the time series
(integer, with min = 1 and max = 2048).}

\item{progress}{Logical: show progress bar?}
}
\value{
A tibble of class "sits" with set of time series
<longitude, latitude, start_date, end_date, label>.
}
\description{
Retrieve a set of time series from a data cube and
and put the result in a \code{sits tibble}. The \code{samples}
parameter should be a \code{data.frame} which
which contains mandatory columns
\code{longitude} and \code{latitude}, and optional columns
\code{start_date}, \code{end_date} and \code{label} for each sample.
}
\examples{
if (sits_run_examples()) {
    # create a cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    raster_cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # read a lat/long from a local cube
    samples <- data.frame(longitude = -55.66738, latitude = -11.76990)
    point_ndvi <- sits_get_data(raster_cube, samples)
}
}
