% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{aws_bucket_list_objects}
\alias{aws_bucket_list_objects}
\title{List objects in an S3 bucket}
\usage{
aws_bucket_list_objects(bucket, ...)
}
\arguments{
\item{bucket}{(character) bucket name. required}

\item{...}{named parameters passed on to
\href{https://www.paws-r-sdk.com/docs/s3_list_objects/}{list_objects}}
}
\value{
if no objects found, an empty tibble. if tibble has rows each
is an S3 bucket, with 8 columns:
\itemize{
\item bucket_name (character)
\item key (character)
\item uri (character)
\item size (fs::bytes)
\item type (character)
\item owner (character)
\item etag (character)
\item last_modified (dttm)
}
}
\description{
List objects in an S3 bucket
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucket_name <- random_bucket()
if (!aws_bucket_exists(bucket_name)) aws_bucket_create(bucket_name)
links_file <- file.path(system.file(), "Meta/links.rds")
aws_file_upload(
  links_file,
  s3_path(bucket_name, basename(links_file))
)
aws_bucket_list_objects(bucket = bucket_name)
# cleanup
six_bucket_delete(bucket_name, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_create}()},
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_download}()},
\code{\link{aws_bucket_exists}()},
\code{\link{aws_bucket_tree}()},
\code{\link{aws_bucket_upload}()},
\code{\link{aws_buckets}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()}
}
\concept{buckets}
