% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_cdf.R
\name{pemp}
\alias{pemp}
\title{Empirical cumulative density function (ECDF)}
\usage{
pemp(q, sample)
}
\arguments{
\item{q}{numeric vector of values to evaluate}

\item{sample}{numeric vector of sample values to base the ECDF on}
}
\value{
Returns the probabilities that a value drawn at random from the
empirical cumulative density based on \emph{sample} is smaller than or
equal to the elements of x.
}
\description{
Empirical cumulative density function based on a sample of observations,
as used by described by Chakraborti (2006).
}
\examples{
x <- 1:5
pemp(1, x)
}
\references{
Chakraborti, S., Hong, B., & Van De Wiel, M. A. (2006).
A note on sample size determination for a nonparametric test of location.
Technometrics, 48(1), 88–94. https://doi.org/10.1198/004017005000000193
}
