% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slcaControl.R
\name{slcaControl}
\alias{slcaControl}
\title{Control Parameters for \code{slca} Estimation}
\usage{
slcaControl(
  em.iterlim = 5000,
  em.tol = 1e-08,
  nlm.iterlim = 1000,
  nlm.tol = 1e-10,
  init.param = NULL,
  nrep = 1,
  test.iter = 500,
  hessian = FALSE,
  na.rm = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{em.iterlim}{an integer specifying the maximum number of iterations allowed for the EM algorithm. The default is \code{5000}.}

\item{em.tol}{a numeric value setting the tolerance for convergence of the EM algorithm. The default is \code{1e-8}.}

\item{nlm.iterlim}{an integer specifying the maximum number of iterations allowed when using the \code{nlm} function for estimation. The default is \code{1000}.}

\item{nlm.tol}{a numeric value setting the tolerance for convergence of the \code{nlm} function. The default is \code{1e-10}.}

\item{init.param}{a numeric vector specifying the initial parameter values for estimation.}

\item{nrep}{an integer specifying the number of estimation trials. The default is \code{1}. Details for generating initial parameter set is described below.}

\item{test.iter}{an integer specifying the maximum number of iterations allowed for parameter testing. The default is \code{500}.}

\item{hessian}{a logical value indicating whether to calculate Hessian via \code{nlm} function numerically, if so, \code{vcov} method can provide variance-covariance matrix with Hessian instead of outer-product-of-gradients (OPG). The default is \code{FALSE}.}

\item{na.rm}{a logical value indicating whether to remove observations containing missing values (\code{NA}). The default is \code{FALSE}. Details for treating missing data is described below.}

\item{verbose}{a logical value indicating whether to display progress updates during the estimation process. The default is \code{FALSE}.

A \code{list} containing control parameters for \code{slca} estimation, including the specified iteration limits, tolerances, and additional options.}
}
\description{
Specifies control parameters for estimating \code{slca} model.
}
\details{
\strong{Missing data:}
Missing data are handled in two ways. If all manifest variables for an observation are missing, the case is excluded (listwise deletion).
For partially missing data, the model assumes Missing At Random (MAR) and uses following algorithm to integrate over the missing values.
In the E-step, posterior probabilities are computed using only the observed items.
In the M-step, parameter updates use these posterior probabilities, with expected counts for missing responses distributed according to current parameter estimates.

\strong{Local maxima and multiple starting values:}
The EM algorithm may converge to a local rather than a global maximum.
To reduce this risk, the \code{nrep} option allows multiple repetitions with different initial values. PI parameters are initialized equally (e.g., 0.5 for two classes), while TAU and RHO parameters are given small random perturbations to uniform probabilities, normalized within each parent state.
The \code{test.iter} option runs a limited number of iterations for each initial set, and the best-performing set is then used for full convergence, improving the chance of reaching the global maximum.
}
\seealso{
\link{slca}
}
