% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_tree}
\alias{ts_tree}
\title{Get a tree from a given tree sequence}
\usage{
ts_tree(ts, i, mode = c("index", "position"), ...)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{i}{Position of the tree in the tree sequence. If \code{mode = "index"},
an i-th tree will be returned (in zero-based indexing as in tskit), if
\code{mode = "position"}, a tree covering the i-th base of the simulated genome will be
returned (again, in tskit's indexing).}

\item{mode}{How should the \code{i} argument be interpreted? Either "index"
as an i-th tree in the sequence of genealogies, or "position" along the
simulated genome.}

\item{...}{Additional keyword arguments accepted by
\code{tskit.TreeSequence.at and tskit.TreeSequence.at_index} methods}
}
\value{
Python-reticulate-based object of the class tskit.trees.Tree
}
\description{
For more information about optional keyword arguments see tskit documentation:
\url{https://tskit.dev/tskit/docs/stable/python-api.html#the-treesequence-class}
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression_slim.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_read(slendr_ts, model)

# extract the zero-th tree in the tree sequence
tree <- ts_tree(ts, i = 0)

# extract the tree at a position in the tree sequence
tree <- ts_tree(ts, i = 100000, mode = "position")
}
