% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-main.R
\name{cov_AR}
\alias{cov_AR}
\title{Covariance estimation by AR fitting}
\usage{
cov_AR(epsilon, model_selec = -1, plot = FALSE)
}
\arguments{
\item{epsilon}{numeric vector. An univariate process.}

\item{model_selec}{integer or \code{-1}. The order of the method, that is the order of the AR process to be fitted on the residuals.
If \code{model_selec = -1}, it is chosen automatically by using the AIC criterion.}

\item{plot}{logical. By default, \code{plot = FALSE}. If \code{plot = TRUE}, then the ACF and the PACF of the vector \code{epsilon} are plotted.}
}
\value{
The function returns the vector of the theoretical autocovariances of the AR process fitted on the process \code{epsilon}.
 \item{model_selec}{the order selected.}
 \item{cov_st}{the vector of theoretical autocovariances of the fitted AR process.}
}
\description{
Fit an autoregressive model to the process and compute the theoretical autocovariances of the fitted AR process.
 By default, the order is chosen by using the AIC criterion (\code{model_selec = -1}).
}
\examples{
x = arima.sim(list(ar=c(0.4,0.2)),1000)
cov_AR(x, model_selec = 2, plot = TRUE)
}
\references{
P.J. Brockwell and R.A. Davis (1991). Time Series: Theory and Methods. \emph{Springer Science & Business Media}.

 E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
