% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-main.R
\name{cov_method}
\alias{cov_method}
\title{Methods to estimate the autocovariances of a process}
\usage{
cov_method(epsilon, method_cov_st = "fitAR", model_selec = -1,
  model_max = NULL, kernel_fonc = NULL, block_size = NULL,
  block_n = NULL, plot = FALSE)
}
\arguments{
\item{epsilon}{numeric vector. An univariate process.}

\item{method_cov_st}{the method chosen by the user to estimate the autocovariances of the error process. The user
has the choice between the methods "fitAR", "spectralproj", "efromovich", "kernel", "select" or "hac". By default, the
"fitAR" method is used.}

\item{model_selec}{integer or \code{-1}. The order of the method. If \code{model_selec = -1}, the method works automatically.}

\item{model_max}{integer. Maximal dimension of the method.}

\item{kernel_fonc}{function. Use this argument if \code{method_cov_st = kernel}. Define the kernel to use in the method. The user can give his own kernel function.}

\item{block_size}{integer. Size of the bootstrap blocks if \code{method_cov_st = kernel}. \code{block_size} must be greater than \code{model_max}.}

\item{block_n}{integer. Blocks number to use for the bootstrap if \code{method_cov_st = kernel}.}

\item{plot}{logical. By default, \code{plot = FALSE}.}
}
\value{
The function returns the autocovariances computed with the chosen method.
}
\description{
This function gives the estimation of the autocovariances of the error process, with the method chosen by the user.
 Five methods are available: "fitAR", "spectralproj", "efromovich", "kernel" and "select".
}
\examples{
x = arima.sim(list(ar=c(0.4,0.2)),1000)
cov_method(x, method_cov_st = "fitAR", model_selec = -1)
}
\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
