% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatch.R
\name{s3_dispatch}
\alias{s3_dispatch}
\title{Illustrate S3 dispatch}
\usage{
s3_dispatch(call, env = parent.frame())
}
\arguments{
\item{call}{Example call to S3 method}

\item{env}{Environment in which to evaluate call}
}
\description{
\code{s3_dispatch()} prints a list of all possible function names that will be
considered for method dispatch. There are four possible states:
\itemize{
\item \code{=>} method exists and is found by \code{UseMethod()}.
\item \code{->} method exists and is used by \code{NextMethod()}.
\item \code{*} method exists but is not used.
\item Nothing (and greyed out in console): method does not exist.
}

Learn more at \url{https://adv-r.hadley.nz/s3.html}.
}
\examples{
x <- Sys.time()
s3_dispatch(print(x))
s3_dispatch(is.numeric(x))
s3_dispatch(as.Date(x))
s3_dispatch(sum(x))

# Internal vs. regular generic
x1 <- 1
x2 <- structure(2, class = "double")

my_length <- function(x) UseMethod("my_length")
s3_dispatch(my_length(x1))
s3_dispatch(my_length(x2))

length.double <- function(x) 10
s3_dispatch(length(x1))
s3_dispatch(length(x2))
}
