% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.spscan.R
\name{summary.spscan}
\alias{summary.spscan}
\title{Summarize object from \code{\link{spscan.test}}.}
\usage{
\method{summary}{spscan}(object, ..., idx = seq_along(object$clusters), digits = 1)
}
\arguments{
\item{object}{An \code{spscan} object.}

\item{...}{Additional arguments affecting the summary produced.}

\item{idx}{An index vector indicating the elements of \code{object$clusters}
to print information for. The default is all clusters.}

\item{digits}{Integer indicating the number of decimal places.}
}
\value{
Returns/prints a data frame. Each row of the data frame summarizes
  the centroid of each cluster, the cluster radius, the number of events in
  the cluster, the number of cases in the cluster, the expected number of
  cases in the cluster, the relative risk of the cluster (cases/events in
  cluster)(cases/events outside cluster), the natural logarithm of the test
  statistic, and the associated p-value.
}
\description{
Summarize object of class \code{scan} from \code{\link{spscan.test}}.
}
\examples{
data(grave)
out = spscan.test(grave, nsim = 99, alpha = 0.8)
summary(out)
}
