% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smfishHmrf.hmrfem.R
\name{smfishHmrf.generate.centroid.save}
\alias{smfishHmrf.generate.centroid.save}
\title{Save the cluster centroids to file}
\usage{
smfishHmrf.generate.centroid.save(kk, name = "test", output_dir = ".")
}
\arguments{
\item{kk}{kmeans object}

\item{name}{name of the run}

\item{output_dir}{output directory; where to save the results}
}
\description{
This function is run after the kmeans step. It takes a kmeans object (containing the kmeans result) as input and save the cluster centroids to file.

Note that the location of saving and the file names are decided by the following rule:
\enumerate{
\item \code{{output_dir}}/k_\code{{par_k}}/f\code{{name}}.gene.ALL.centroid.txt
\item \code{{output_dir}}/k_\code{{par_k}}/f\code{{name}}.gene.ALL.kmeans.txt
}

where \code{{}} refers to the value of parameters.
}
\examples{
expr_file = system.file("extdata", "ftest.expression.txt", package="smfishHmrf")
y<-smfishHmrf.read.expression(expr_file)
kk = smfishHmrf.generate.centroid(y, par_k=9, par_seed=100, nstart=100)
smfishHmrf.generate.centroid.save(kk, name="test", output_dir=tempdir())
}
