% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_expected_total_infections.R
\name{get_expected_total_infections}
\alias{get_expected_total_infections}
\title{Expected number of total symptomatic infections}
\usage{
get_expected_total_infections(
  group_size,
  last_day_reported_infection,
  total_reported_infections,
  meanlog = 1.69,
  sdlog = 0.55
)
}
\arguments{
\item{group_size}{integer, size of the group.}

\item{last_day_reported_infection}{Number of days the last infection was reported after the event (0 = event day).}

\item{total_reported_infections}{Number of reported symptomatic infections so far.}

\item{meanlog}{Number, the parameter of mean from the log-normal distribution.}

\item{sdlog}{Number, the parameter of sd from the log-normal distribution.}
}
\value{
The total number of expected symptomatic infections.
}
\description{
Calculates the expected total number of symptomatic infections after a group event,
based on the observed infections so far.
}
\details{
meanlog and sdlog are the log-normal distribution parameters derived from
the incubation period characteristics described in Xin et al. (2021).
Note that the function often clearly overestimates the number of symptomatic infections
if last_day_reported_infections is less than 3.
}
\examples{
get_expected_total_infections(25, 5, 4)

}
