% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_future_infections.R
\name{predict_future_infections}
\alias{predict_future_infections}
\title{Prediction of future infections per day}
\usage{
predict_future_infections(
  last_day_reported_infection,
  total_reported_infections,
  total_expected_infections,
  meanlog = 1.69,
  sdlog = 0.55
)
}
\arguments{
\item{last_day_reported_infection}{Number of days the last infection was reported after the event (0 = event day).}

\item{total_reported_infections}{Number of reported symptomatic infections so far.}

\item{total_expected_infections}{Number of expected symptomatic infections in total.}

\item{meanlog}{Number, the parameter of mean from the log-normal distribution.}

\item{sdlog}{Number, the parameter of sd from the log-normal distribution.}
}
\value{
Vector with expected future infections per day after the event.
}
\description{
Predicts how many people are expected to develop symptoms on each
day after the last reported infection after a group event.
}
\details{
meanlog and sdlog are the log-normal distribution parameters derived from
the incubation period characteristics described in Xin et al. (2021).
}
\examples{
predict_future_infections(last_day_reported_infection = 3,
                          total_reported_infections = 5,
                          total_expected_infections = 15)

}
\references{
Xin H, Wong JY, Murphy C et al. (2021) "The Incubation Period
Distribution of Coronavirus Disease 2019: A Systematic Review and Meta-Analysis".
\emph{Clinical Infectious Diseases}, 73(12): 2344-2352.
}
