# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @rdname single-matern
#' @keywords internal
single_exp <- function(d, sigsq, phi) {
    .Call(`_smile_single_exp`, d, sigsq, phi)
}

#' @rdname single-matern
#' @keywords internal
single_matern3 <- function(d, sigsq, phi) {
    .Call(`_smile_single_matern3`, d, sigsq, phi)
}

#' @rdname single-matern
#' @keywords internal
single_matern5 <- function(d, sigsq, phi) {
    .Call(`_smile_single_matern5`, d, sigsq, phi)
}

#' @title Matern covariance function (scalar - generic)
#'
#' @description Computing the Matern covariance function for a scalar distance,
#'   adapted from \code{geoR}.
#'
#' @details \code{single_matern3} and \code{single_matern5} are optimized for
#'   when \eqn{\nu} is 1.5 or 2.5, respectively. Similarly, \code{single_exp}
#'   and \code{single_gauss} represent the cases where \eqn{\nu = 0.5} or
#'   \eqn{\nu \to \infty}. In other words, they are the exponential and
#'   Gaussian covariance functions.
#' 
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu} parameter from the Matern covariance function,
#'   controls the differentiability of the process.
#' @name single-matern
#' 
#' @return a scalar representing the (matern) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_matern3}}, \code{\link{single_matern5}}
#'   \code{\link{single_exp}}, \code{\link{mat_cov}}
#' 
#' @keywords internal
single_matern <- function(d, sigsq, phi, nu) {
    .Call(`_smile_single_matern`, d, sigsq, phi, nu)
}

#' @title Powered Exponential covariance function (scalar)
#'
#' @description Computing the Powered Exponential covariance function for a
#'   scalar distance.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Exponential covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Exponential covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu \in (0, 2]} parameter representing the "power"
#'
#' @return a scalar representing the (exponential) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{single_matern3}}, \code{\link{single_matern5}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
single_pexp <- function(d, sigsq, phi, nu) {
    .Call(`_smile_single_pexp`, d, sigsq, phi, nu)
}

#' @rdname single-matern
#' @keywords internal
single_gauss <- function(d, sigsq, phi) {
    .Call(`_smile_single_gauss`, d, sigsq, phi)
}

#' @title Spherical covariance function (scalar)
#'
#' @description Computing the Spherical covariance function for a scalar
#'   distance.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance.
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return a scalar representing the (gaussian) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{single_matern3}}, \code{\link{single_matern5}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
single_spher <- function(d, sigsq, phi) {
    .Call(`_smile_single_spher`, d, sigsq, phi)
}

#' @title Cubic spline covariance function (scalar)
#'
#' @description Computing the Spherical covariance function for a scalar
#'   distance.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance.
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return a scalar representing the (gaussian) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{single_matern3}}, \code{\link{single_matern5}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
single_cs <- function(d, sigsq, phi) {
    .Call(`_smile_single_cs`, d, sigsq, phi)
}

#' @rdname gw
single_gw0 <- function(d, sigsq, phi, mu) {
    .Call(`_smile_single_gw0`, d, sigsq, phi, mu)
}

#' @rdname gw
single_gw1 <- function(d, sigsq, phi, mu) {
    .Call(`_smile_single_gw1`, d, sigsq, phi, mu)
}

#' @rdname gw
single_gw2 <- function(d, sigsq, phi, mu) {
    .Call(`_smile_single_gw2`, d, sigsq, phi, mu)
}

#' @rdname gw
single_gw3 <- function(d, sigsq, phi, mu) {
    .Call(`_smile_single_gw3`, d, sigsq, phi, mu)
}

#' @title Matern Generalized Wendland (GW) covariance function
#'   (scalar - generic)
#'
#' @description adapted from Bevilacqua et al. 2019.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param kappa \eqn{\kappa \in \{0, \ldots, 3 \}}.
#' @param mu a parameter that controls the smoothness of the covariance
#'   function. Note that, \eqn{\mu \geq 1}.
#' 
#' @return a scalar representing the GW covariance between two
#'   observations \code{d} apart of each other.
#'
#' @name gw
#' 
#' @keywords internal
single_gw <- function(d, sigsq, phi, kappa, mu) {
    .Call(`_smile_single_gw`, d, sigsq, phi, kappa, mu)
}

#' @title Matern covariance function for a given distance matrix.
#'
#' @description Computing the Matern covariance function for a matrix of
#'   distances.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu} parameter from the Matern covariance function,
#'   controls the differentiability of the process.
#' 
#' @return The matern covariance function (for a stationary and isotropic
#'   process) associated with the provided distances (\code{dists}) and the
#'   given set of parameters.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}}
#'
#' @keywords internal
mat_cov <- function(dists, sigsq, phi, nu) {
    .Call(`_smile_mat_cov`, dists, sigsq, phi, nu)
}

#' @title Matern covariance function for polygons.
#'
#' @description Computing the Matern covariance function between polygons.
#'
#' @param cross_dists a \code{list} such that each position contains the cross
#'   distances between points within different polygons.
#' @rdname mat_cov
#' @return The matern covariance matrix associated with a set of polygons.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{mat_cov}}
#' 
#' @keywords internal
comp_mat_cov <- function(cross_dists, n, n2, sigsq, phi, nu) {
    .Call(`_smile_comp_mat_cov`, cross_dists, n, n2, sigsq, phi, nu)
}

#' @title Powered Exponential Covariance
#' @rdname mat_cov
pexp_cov <- function(dists, sigsq, phi, nu) {
    .Call(`_smile_pexp_cov`, dists, sigsq, phi, nu)
}

#' @title Powered Exponential Covariance for polygons
#' @rdname mat_cov
comp_pexp_cov <- function(cross_dists, n, n2, sigsq, phi, nu) {
    .Call(`_smile_comp_pexp_cov`, cross_dists, n, n2, sigsq, phi, nu)
}

#' @title Gaussian Covariance
#' @rdname mat_cov
gauss_cov <- function(dists, sigsq, phi) {
    .Call(`_smile_gauss_cov`, dists, sigsq, phi)
}

#' @title Gaussian Covariance for polygons
#' @rdname mat_cov
comp_gauss_cov <- function(cross_dists, n, n2, sigsq, phi) {
    .Call(`_smile_comp_gauss_cov`, cross_dists, n, n2, sigsq, phi)
}

#' @title Spherical Covariance
#' @rdname mat_cov
spher_cov <- function(dists, sigsq, phi) {
    .Call(`_smile_spher_cov`, dists, sigsq, phi)
}

#' @title Spherical Covariance for polygons
#' @rdname mat_cov
comp_spher_cov <- function(cross_dists, n, n2, sigsq, phi) {
    .Call(`_smile_comp_spher_cov`, cross_dists, n, n2, sigsq, phi)
}

#' @title Cubic Spline Covariance
#' @rdname mat_cov
cs_cov <- function(dists, sigsq, phi) {
    .Call(`_smile_cs_cov`, dists, sigsq, phi)
}

#' @title Cubic Spline Covariance for polygons
#' @rdname mat_cov
comp_cs_cov <- function(cross_dists, n, n2, sigsq, phi) {
    .Call(`_smile_comp_cs_cov`, cross_dists, n, n2, sigsq, phi)
}

#' @title Generalized Wendland Covariance
#' @rdname mat_cov
gw_cov <- function(dists, sigsq, phi, kappa, mu) {
    .Call(`_smile_gw_cov`, dists, sigsq, phi, kappa, mu)
}

#' @title Generalized Wendland Covariance for polygons
#' @rdname mat_cov
comp_gw_cov <- function(cross_dists, n, n2, sigsq, phi, kappa, mu) {
    .Call(`_smile_comp_gw_cov`, cross_dists, n, n2, sigsq, phi, kappa, mu)
}

#' @title Creating a symmetric distance matrix (Eigen version)
#' @description Computes the Euclidean distance between all pairs of rows in a
#'   matrix.
#' @param my_mat A matrix where each row is a 2D coordinate.
#' @keywords internal
distmat <- function(my_mat) {
    .Call(`_smile_distmat`, my_mat)
}

#' @title Pairwise distances between two matrices (Eigen version)
#' @description Computes Euclidean distance between rows of m1 and rows of m2.
#' @param m1 A matrix where each row is a 2D coordinate.
#' @param m2 A matrix where each row is a 2D coordinate.
#' @keywords internal
crossdist <- function(m1, m2) {
    .Call(`_smile_crossdist`, m1, m2)
}

#' @title Pairwise distances for a list of matrices (Internal use)
#' @param mat_list internal use
#' @param mat_list1 internal use
#' @param mat_list2 internal use
#' @param return_single internal use
#' @param pred_mat internal use
#' @param x_to_list internal use
#' @param by internal use
#' @param y_grid internal use
#' @param x_grid internal use
#' @name aux_mat
#' @keywords internal
single_dists <- function(mat_list) {
    .Call(`_smile_single_dists`, mat_list)
}

#' @title Cross-distances for two lists of matrices (Eigen version)
#' @rdname aux_mat
#' @keywords internal
mult_dists <- function(mat_list1, mat_list2, return_single) {
    .Call(`_smile_mult_dists`, mat_list1, mat_list2, return_single)
}

#' @title Prediction cross-distances (Eigen version)
#' @rdname aux_mat
#' @keywords internal
pred_cdist <- function(mat_list, pred_mat) {
    .Call(`_smile_pred_cdist`, mat_list, pred_mat)
}

