% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-chaikin.R
\name{smooth_chaikin}
\alias{smooth_chaikin}
\title{Chaikin's corner cutting algorithm}
\usage{
smooth_chaikin(x, wrap = FALSE, refinements = 3L)
}
\arguments{
\item{x}{numeric matrix; 2-column matrix of coordinates.}

\item{wrap}{logical; whether the coordinates should be wrapped at the ends,
as for polygons and closed lines, to ensure a smooth edge.}

\item{refinements}{integer; number of corner cutting iterations to apply.}
}
\value{
A matrix with the coordinates of the smoothed curve.
}
\description{
Chaikin's corner cutting algorithm smooths a curve by iteratively replacing
every point by two new points: one 1/4 of the way to the next point and one
1/4 of the way to the previous point.
}
\details{
This function works on matrices of points and is generally not called
directly. Instead, use \code{\link[=smooth]{smooth()}} with \code{method = "chaikin"} to apply this
smoothing algorithm to spatial features.
}
\examples{
# smooth_chaikin works on matrices of coordinates
# use the matrix of coordinates defining a polygon as an example
m <- jagged_polygons$geometry[[2]][[1]]
m_smooth <- smooth_chaikin(m, wrap = TRUE)
class(m)
class(m_smooth)
plot(m, type = "l", axes = FALSE, xlab = NA, ylab = NA)
lines(m_smooth, col = "red")

# smooth is a wrapper for smooth_chaikin that works on spatial features
library(sf)
p <- jagged_polygons$geometry[[2]]
p_smooth <- smooth(p, method = "chaikin")
class(p)
class(p_smooth)
plot(p)
plot(p_smooth, border = "red", add = TRUE)
}
\references{
The original reference for Chaikin's corner cutting algorithm is:
\itemize{
\item \verb{Chaikin, G. An algorithm for high speed curve generation. Computer Graphics and Image Processing 3 (1974), 346–349}
}

This implementation was inspired by the following StackOverflow answer:
\itemize{
\item \href{https://stackoverflow.com/a/47255374/3591386}{Where to find Python implementation of Chaikin's corner cutting algorithm?}
}
}
\seealso{
\code{\link[=smooth]{smooth()}}
}
