% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sobolnp.R
\name{plot}
\alias{plot}
\alias{plot.sobolnp}
\title{Plot method for objects \code{sobolnp}}
\usage{
plot(snp, ...)

\method{plot}{sobolnp}(snp, ...)
}
\arguments{
\item{snp}{an object of class \code{sobolnp}}

\item{...}{further arguments passed to the \code{plot} function}
}
\value{
A formatted table with the results of the \code{\link{sobolnp}}
function.
}
\description{
Plot the Sobol indices based in a non-parametric regression
with cross-validation and bootstrap bandwidth
}
\examples{

ishigami.fun <- function(X) {
A <- 7
B <- 0.1
sin(X[, 1]) + A * sin(X[, 2])^2 + B * X[, 3]^4 * sin(X[, 1])
}

X <- matrix(runif(3*100, -pi, pi), ncol = 3)
Y <- ishigami.fun(X)

estimation <- sobolnp(Y = Y, X = X, nboot = 5)

plot(estimation)

}
