% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_age.r
\name{pop_age}
\alias{pop_age}
\title{Change age groups in population data}
\usage{
pop_age(
  pop,
  age.limits,
  pop.age.column = "lower.age.limit",
  pop.column = "population",
  ...
)
}
\arguments{
\item{pop}{a data frame with columns indicating lower age limits and population sizes (see 'age.column' and 'pop.column')}

\item{age.limits}{lower age limits of age groups to extract}

\item{pop.age.column}{column in the 'pop' data frame indicating the lower age group limit}

\item{pop.column}{column in the 'pop' data frame indicating the population size}

\item{...}{ignored}
}
\value{
data frame of age-specific population data
}
\description{
This changes population data to have age groups with the given age.limits, extrapolating linearly between age groups (if more are requested than available) and summing populations (if fewer are requested than available)
}
\examples{
ages_it_2015 <- wpp_age("Italy", 2015)

# Modify the age data.frame to get age groups of 10 years instead of 5
pop_age(ages_it_2015, age.limit = seq(0, 100, by = 10))

# The function will also automatically interpolate if necessary
pop_age(ages_it_2015, age.limit = c(0, 18, 40, 65))

}
