% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/banzhaf.R
\name{ordinalBanzhafScores}
\alias{ordinalBanzhafScores}
\alias{ordinalBanzhafRanking}
\title{Ordinal Banzhaf ranking}
\usage{
ordinalBanzhafScores(powerRelation, elements = powerRelation$elements)

ordinalBanzhafRanking(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{elements}{Vector of elements of which to calculate their scores.
By default, the scores of all elements in \code{powerRelation$elements} are considered.}
}
\value{
Score function returns list of class type \code{OrdinalBanzhafScores} and length of \code{powerRelation$elements}.
Each index contains a vector of three numbers, the number of positive marginal contributions, the number of negative marginal contributions, and the number of coalitions for which no comparison could be done.
The first two numbers summed together gives us the actual ordinal Banzhaf score.

Ranking function returns corresponding \code{\link{SocialRanking}} object.
}
\description{
Calculate the Ordinal Banzhaf scores, the number of positive and the number of negative marginal contributions.

\code{ordinalBanzhafRanking()} returns the corresponding ranking.
}
\details{
Inspired by the Banzhaf index \insertCite{1964Banzhaf}{socialranking}, the Ordinal Banzhaf
determines the score of element \eqn{i}{i} by adding the amount of coalitions
\eqn{S \subseteq N \setminus \lbrace i \rbrace}{S \\subseteq N \\ \{i\}}
its contribution impacts positively (\eqn{S \cup \lbrace i \rbrace \succ S}{S u \{i\} > S })
and subtracting the amount of coalitions where its contribution
had a negative impact (\eqn{S \succ S \cup \lbrace i \rbrace}{S > S u \{i\}})\insertCite{2019OrdinalBanzhaf}{socialranking}.

The original definition only takes total power relations into account, where either \eqn{S \succsim T}{S >= T} or \eqn{T \succsim S}{T >= S}
for every \eqn{S,T \subseteq N}{S,T subseteq N}.
If coalitions are missing from the power relation, we may not be able to perform certain comparisons.
To indicate these missing comparisons, the ordinal Banzhaf score of an element \eqn{i}{i} also includes that number at index \code{3}.
I.e., if the ordinal Banzhaf score of an element is \code{c(4, -2, 1)}, it means that it contributed positively to \code{4} coalitions and negatively to \code{2} others.
For one coalition, no comparison could be made.
}
\examples{
pr <- as.PowerRelation("12 > (2 ~ {}) > 1")

# Player 1 contributes positively to {2}
# Player 1 contributes negatively to {empty set}
# Therefore player 1 has a score of 1 - 1 = 0
#
# Player 2 contributes positively to {1}
# Player 2 does NOT have an impact on {empty set}
# Therefore player 2 has a score of 1 - 0 = 0
ordinalBanzhafScores(pr)
# `1` = c(1, -1, 0)
# `2` = c(1, 0, 0)

ordinalBanzhafRanking(pr)
# 1 > 2

}
\references{
\insertRef{2019OrdinalBanzhaf}{socialranking}

\insertRef{1964Banzhaf}{socialranking}
}
\seealso{
Other ranking solution functions: 
\code{\link{L1Scores}()},
\code{\link{L2Scores}()},
\code{\link{LPSScores}()},
\code{\link{LPScores}()},
\code{\link{copelandScores}()},
\code{\link{cumulativeScores}()},
\code{\link{kramerSimpsonScores}()},
\code{\link{lexcelScores}()}
}
\concept{ranking solution functions}
