% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centers.R
\name{lon_lat_from_area}
\alias{lon_lat_from_area}
\title{Grab the longitude/latitude of the center of population of a census area}
\usage{
lon_lat_from_area(geoid = NULL, state = NULL, county = NULL, year = 2020)
}
\arguments{
\item{geoid}{A single string specifying the geoid of a census area. Must be
2, 5, 11, or 12 digits. Must be \code{NULL} if \code{state} is not \code{NULL}.}

\item{state}{A single string containing the FIPS code, two-letter
abbreviation, or full state name of a US state or the District of Columbia
or Puerto Rico. Not case sensitive. Must be \code{NULL} if \code{geoid} is not
\code{NULL}.}

\item{county}{A single string specifying the name of a county in \code{state} or
the three- or five-digit GEOID of a county in \code{state}. Not case sensitive.
If entering a county name, it must match the beginning of only one of the
county names in \code{state}. If entering a five-digit GEOID, it will throw an
error if its first two digits do not match the GEOID of \code{state}. Must be
\code{NULL} if state is \code{NULL}.}

\item{year}{One of 2020, 2010, or 2000. Defaults to 2020.}
}
\value{
A \link{double} vector of length 2. The first element is LONGITUDE
(positive for east, negative for west). The second element is LATITUDE
(positive for north, negative for south).
}
\description{
The user specifies a census area, and the function returns the
longitude/latitude coordinates of the area's center of population according
to the decennial census.
}
\details{
Centers of population are based on the decennial census. Only states,
counties, tracts, and block groups are currently supported. See the
documentation of the \code{USpopcenters} package and
\url{https://www.census.gov/geographies/reference-files/time-series/geo/centers-population.html}
for more information.

Requires the data package \code{USpopcenters} to be installed.
}
\examples{
if (requireNamespace("USpopcenters", quietly = TRUE)) {
 
# The center of population of Alaska
lon_lat_from_area(state = "alAskA")

# The center of population of Cook County, Illinois.
lon_lat_from_area(state = "IL", county = "Cook")

# The center of population of some tract in Manhattan
lon_lat_from_area(geoid = "36061021600")
}
}
\seealso{
\code{\link[=areas_in_radius]{areas_in_radius()}}
}
