% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilchemistry.R
\name{SP}
\alias{SP}
\title{Supply parameter of phosphorus in soil}
\usage{
SP(W = W, V = V, Ci = Ci, Cf = Cf,...)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{V}{Volume of extractant solution (mL)}

\item{Ci}{Initial concentration (mg/L) of the added element, e.g., phosphorus}

\item{Cf}{Final or equilibrium concentration (mg/L) after adsorption of the same element}

\item{...}{Any other argument that can be passed to base plot}
}
\value{
SP - Supply parameter (mg^0.5)/(kg L)^0.25
}
\description{
This function generates the supply parameter (SP) of phosphorus in soil as described by Khasawneh and Copeland (1973).
}
\examples{
with(data = df_sordes, SP(W = 2, V = 20, Ci = Initial_conc, Cf = Equilibrium_conc,
col = rgb(red = 1, green = 0, blue = 0, alpha = 0.5), pch = 16, cex = 1))
}
\references{
Khasawneh, F.E., 1971. Solution ion activity and plant growth. Soil Science Society of America Proceedings 35, 426–436.
Khasawneh, F.E., Copeland, J.P., 1973. Cotton root growth and uptake of nutrients: relation of phosphorus uptake to quantity, intensity, and buffering capacity. Soil Science Society of America Proceedings 37, 250–254.
}
