% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soma.R
\name{soma}
\alias{soma}
\alias{bounds}
\alias{plot.soma}
\title{The Self-Organising Migrating Algorithm}
\usage{
soma(costFunction, bounds, options = list(), init = NULL, ...)

bounds(min, max)

\method{plot}{soma}(x, y = NULL, add = FALSE, ...)
}
\arguments{
\item{costFunction}{A cost function which takes a numeric vector of
parameters as its first argument, and returns a numeric scalar
representing the associated cost value.}

\item{bounds}{A list with elements \code{min} and \code{max}, each a numeric
vector giving the upper and lower bounds for each parameter, respectively.}

\item{options}{A list of options for the SOMA algorithm itself, usually
generated by functions like \code{\link{all2one}}.}

\item{init}{An optional matrix giving the starting population's positions in
parameter space, one per column. If omitted, initialisation is random (as
is usual for SOMA), but specifying a starting state can be helpful when
running the algorithm in stages or investigating the consistency of
solutions.}

\item{\dots}{Additional parameters to \code{costFunction} (for \code{soma})
or the default plotting method (for \code{plot.soma}).}

\item{min, max}{Vectors of minimum and maximum bound values for each
parameter to the \code{costFunction}.}

\item{x}{An object of class \code{"soma"}.}

\item{y}{Ignored.}

\item{add}{If \code{TRUE}, add to an existing plot canvas.}
}
\value{
A list of class \code{"soma"}, containing the following elements.
  \describe{
    \item{leader}{The index of the ``leader'', the individual in the
      population with the lowest cost.}
    \item{population}{A matrix whose columns give the parameter values for
      each individual in the population at convergence.}
    \item{cost}{A vector giving the cost function values for each individual
      at convergence.}
    \item{history}{A vector giving the cost of the leader for each migration
      during the optimisation. This should be nonincreasing.}
    \item{migrations}{The number of migrations completed.}
    \item{evaluations}{The number of times the \code{costFunction} was
      evaluated.}
  }
  A \code{plot} method is available for this class, which shows the history
    of leader cost values during the optimisation.
}
\description{
The Self-Organising Migrating Algorithm (SOMA) is a general-purpose,
stochastic optimisation algorithm. The approach is similar to that of
genetic algorithms, although it is based on the idea of a series of
``migrations'' by a fixed set of individuals, rather than the development
of successive generations. It can be applied to any cost-minimisation
problem with a bounded parameter space, and is robust to local minima.
}
\examples{
# Rastrigin's function, which contains many local minima
rastrigin <- function (x) 10 * length(x) + sum(x^2 - 10 * cos(2*pi*x))

# Find the global minimum over the range -5 to 5 in each parameter
x <- soma(rastrigin, bounds(c(-5,-5), c(5,5)))

# Find the location of the leader - should be near the true minimum of c(0,0)
print(x$population[,x$leader])

# Plot the cost history of the leaders
plot(x)
}
\references{
I. Zelinka (2004). SOMA - self-organizing migrating algorithm. In G.C.
  Onwubolu & B.V. Babu, eds, New optimization techniques in engineering.
  Volume 141 of ``Studies in Fuzziness and Soft Computing'', pp. 167-217.
  Springer.
}
\seealso{
\code{\link{soma.options}} for setting options. \code{\link{optim}}
  implements other general-purpose optimisation methods.
}
\author{
R implementation by Jon Clayden <code@clayden.org>.
}
