% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{PressureToDepthSaundersFofonoff}
\alias{PressureToDepthSaundersFofonoff}
\title{Pressure To Depth from Saunders and Fofonoff 1976}
\source{
Unesco, 1983
Algorithms for computation of fundamental properties of
 seawater, 1983. Unesco Tech. Pap. in Mar. Sci., No. 44, 53 pp.
}
\usage{
PressureToDepthSaundersFofonoff(P, latitude)
}
\arguments{
\item{P,}{pressure in MPa (relative to atmospheric pressure)}

\item{latitude,}{latitude in degrees}
}
\value{
the depth
}
\description{
Returns the Pressure To Depth from Saunders and Fofonoff 1992
CHECKVALUE: DEPTH = 9712.653 M FOR P=10000 DECIBARS, LATITUDE=30 DEG
ABOVE FOR STANDARD OCEAN: T=O DEG. CELSIUS; S=35 (PSS-78)
}
\examples{
PressureToDepthSaundersFofonoff(0.1, 0)
}
\author{
Jose Gama
}
\references{
Saunders P.M., Fofonoff N.P., 1976
Conversion of pressure to depth in the ocean. Deep Sea Research 23:109-111
}

